// Autor: Ivan Katanic

#include <algorithm>
#include <cassert>
#include <cstring>
#include <iostream>

using namespace std;

typedef long long llint;

int main(void) {
  int N;
  scanf("%d", &N);

  vector<int> a(N);
  for (int i = 0; i < N; ++i) {
    scanf("%d", &a[i]);
  }

  int H = *max_element(a.begin(), a.end()) + 1;
  vector<int> first(H, -1), last(H, -1);
  for (int i = 0; i < N; ++i) {
    last[a[i]] = i;
  }
  for (int i = N-1; i >= 0; --i) {
    first[a[i]] = i;
  }

  vector<int> hs;
  for (int h = 0; h < H; ++h) {
    if (first[h] != -1) {
      hs.push_back(h);
    }
  }

  int M = hs.size();
  vector<pair<llint, llint>> f(M);
  f[0] = {last[hs[0]] - first[hs[0]], last[hs[0]] - first[hs[0]]};
  for (int i = 0; i < M-1; ++i) {
    int range = last[hs[i+1]] - first[hs[i+1]];
    f[i+1].first = range + min(abs(last[hs[i+1]]-first[hs[i]]) + f[i].first,
                               abs(last[hs[i+1]]-last[hs[i]]) + f[i].second);
    f[i+1].second = range + min(abs(first[hs[i+1]]-first[hs[i]]) + f[i].first,
                                abs(first[hs[i+1]]-last[hs[i]]) + f[i].second);
  }

  llint ans = min(f[M-1].first, f[M-1].second);
  printf("%lld\n", ans);
  return 0;
}
